# Cross Join

Joe 需要生成 goods 表

```sql
create table goods(
    id int primary key auto_increment,
    category varchar(64),
    name varchar(256),
    price decimal(12, 4),
    stock int,
    upper_time timestamp
)
```

中所有T恤（category为`T-Shirt`）的所有尺寸，尺寸信息在 size 表

```sql
create table size(
    id int primary key auto_increment,
    name varchar(16)
)
```

中，那么这个查询应该是：

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
select g.id, g.name, s.name as size
from goods as g
    cross join size as s
where g.category = 'T-Shirt';
```

## 选项

### A

```sql
select g.id, g.name, s.name as size
from goods as g
    full join size as s
where g.category = 'T-Shirt';
```

### B

```sql
select g.id, g.name, s.name as size
from goods as g
    left join size as s
where g.category = 'T-Shirt';
```

### C

```sql
select g.id, g.name, s.name as size
from goods as g
    left join size as s
where g.category = 'T-Shirt';
```

### D

```sql
select g.id, g.name, s.name as size
from goods as g
    right join size as s
where g.category = 'T-Shirt';
```

### E

```sql
select g.id, g.name, s.name as size
from goods as g
    outter join size as s
where g.category = 'T-Shirt';
```


